/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Single Point A/D
/* - Contents: α׷ COMICX_AD_GetVolt(...)Լ Ͽ 
/*     Single point A/D ϴ α׷Դϴ.
/*
/* - Remarks : 
/*     1.   COMI-ST201 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMICX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasCX.h"

#define DEV_ID	COMI_ST201
#define CHAN	 0
#define VMIN	-10 
#define VMAX	 10

void main (void)
{
	HANDLE hDevice;
	float ad_volt;

	if(!COMICX_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMICX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMICX_UnloadDll();
		exit(0);
	}

	// Analog Input type 'Single ended' Ѵ. //
	// Differential Է ϰ Ѵٸ AI_SINGLEſ  //
	// AI_DIFF  Ͽ Ѵ.                          //
	COMICX_AD_SetInputType (hDevice, AI_SINGLE);

	COMICX_AD_SetRange (hDevice, CHAN, VMIN, VMAX);
	printf("A/D ȯ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();	
	while (!_kbhit())
	{
		ad_volt = COMICX_AD_GetVolt (hDevice, CHAN);
		printf("A/D Result (volt) = %6.2f\n", ad_volt);
		Sleep(500);
	}
	
	COMICX_UnloadDevice(hDevice);
	COMICX_UnloadDll();
}
